clear
run AttyFee2007Definitions.do


/// Evalutation Fee Calculator
reg  lnfeeexpord lnroles lnassets lndaysin yearconfirmed lnemployees shop saleall [pw=pweight], vce(robust)
predict evalfees
gen unevalfees = exp(evalfees)
gen evalpct = feeexpord / unevalfees

reg  lnfeeexpord lnassets prepack preneg lnsales xyearfiled shop [pw=pweight], vce(robust)
predict predfees
gen unpredfees = exp(predfees)
gen predpct = feeexpord / unpredfees
list xnamecorp feeexpord unpredfees evalpct predpct predevalpct

gen predevalpct = unpredfees / unevalfees
hist predevalpct

gen sortpct = predevalpct*-1

graph drop _all

/// Horizontal bar graph of actual vs predicted as a percent of predicted
/// Still need to figure out the labeling on the vertical axis
graph hbar (sum) actual, ///
	over(unpredfees, relabel(1 "500k" 26 "500M" 40 "10M" 58 "20M" 79 "50M" 100 "500M") ///
	sort(sortpct)) ytitle(Less than predicted           Predicted             More than predicted)  /// 
	yscale(range(-1.5 1.5)) ///
	ylabel(-1 "0%" -.5 "50%" 0"100%" .5 "150%" 1 "200%" 1.5 "250%") name(HBAR1, replace)

graph bar (sum) actual, ///
	over(predevalpct, relabel(1 "500k" 26 "500M" 40 "10M" 58 "20M" 79 "50M" 100 "500M") ///
	sort(sortpct)) ytitle(Less than predicted           Predicted             More than predicted)  /// 
	yscale(range(-1.5 1.5)) ///
	ylabel(-1 "0%" -.5 "50%" 0"100%" .5 "150%" 1 "200%" 1.5 "250%") name(BAR1, replace)	
	
/// Lowess smoother 
lowess feeexpord unpredfees, /// 
	xlabel(500000 "500k" 1000000 "1M" 5000000 "5M" 10000000 "10M" 50000000"50M" 100000000 "100M" ///
		250000000 "250M" 500000000 "500M") ///
	ylabel(500000 "500k" 5000000 "5M" 100000000 "100M"  250000000 "250M" 500000000 "500M") ///
	ytitle("Fees and Expenses") xtitle("Predicted Fees and Expenses") ///
	name(All) title("Predicted vs Actual Fees")
	
/// Lowess smoother for lower half of cases
lowess feeexpord unpredfees if feeexpord < 12000000, /// 
	xlabel(500000 "500k" 5000000 "5M" 10000000 "10M" 15000000 "15M" 20000000 "20M") ///
	ylabel(500000 "500k" 5000000 "5M" 10000000 "10M") ///
	ytitle("Fees and Expenses") xtitle("Predicted Fees and Expenses") ///
	title("Predicted vs Actual Fees, < $12,000,000") ///
	name(LT12M)

/// Lowess smoother for cases 12M to 282M	
lowess feeexpord unpredfees if feeexpord > 12000000 & feeexpord < 300000000, /// 
	xlabel(10000000 "10M" 50000000 "50M" 100000000 "100M" 200000000 "200M" 300000000 "300M") ///
	ylabel(10000000 "10M" 100000000 "100M" 200000000 "200M" 300000000 "300M") ///
	ytitle("Fees and Expenses") xtitle("Predicted Fees and Expenses") ///
	name(GT12M) title("Predicted vs Actual Fees, >$12,000,000")
	
/// Lowess smoother with log10 scale
lowess feeexpord unpredfees, yscale(log) xscale(log) /// 
	xlabel(500000 "500k"  5000000 "5M" 50000000"50M" 500000000 "500M") ///
	ylabel(500000 "500k" 5000000 "5M" 50000000"50M" 500000000 "500M") ///
	ytitle("Fees and Expenses") xtitle("Predicted Fees and Expenses") ///
	name(All_Log10) title("Predicted vs Actual Fees, Log10")
	
/// Lowess smoother with Log10 scale, setting bottom of scale to Zero	
lowess feeexpord unpredfees, yscale(log) xscale(log) /// 
	xlabel(1 "1" 500000 "500k" 1000000 "1M" 5000000 "5M" 10000000 "10M" 50000000"50M" 100000000 "100M" 500000000 "500M") ///
	ylabel(1 "1" 500000 "500k" 5000000 "5M" 50000000 "50M" 500000000 "500M") ///
	ytitle("Fees and Expenses") xtitle("Predicted Fees and Expenses") ///
	title("Predicted vs Actual Fees, Scale starting at 0") name(All_Log10_at_0)

twoway (lfitci  lnfeeexpord predfees, stdf level(68)) (scatter lnfeeexpord predfees), ///
	name(CI_68)
